<html>
<head>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
</head>
<body>

<h3>HTTP PUT request with XML Body Example</h3>
<form id="article-form">
    <pre>
         id: <input type="text" name="id">
    content: <input type="text" name="content">
                  <input type="submit" value="Submit">
    </pre>
</form>
<br/>
<div id="result"></div>

<script>
 $("#article-form").submit(function(event){
            event.preventDefault();
            var form = $(this);
            var id = form.find('input[name="id"]').val();
            var url = 'http://localhost:8080/articles/'+id;
            var content = form.find('input[name="content"]').val();
            //preparing xml document
            var xmlDocument = $.parseXML("<article/>");
            var idNode = xmlDocument.createElement('id');
            idNode.appendChild(document.createTextNode(id));
            xmlDocument.documentElement.appendChild(idNode);
            var contentNode = xmlDocument.createElement('content');
            contentNode.appendChild(document.createTextNode(content));
            xmlDocument.documentElement.appendChild(contentNode);
            var xmlString = xmlToString(xmlDocument);
            console.log(xmlString);
            $.ajax({
                type : 'PUT',
                url : url,
                contentType: 'application/xml',
                data : xmlString,
                success : function(data, status, xhr){
                   $("#result").html(data+
                   " link: <a href='"+url+"'>"+url+"</a>");
                },
                error: function(xhr, status, error){
                  alert(error);
                }
            });
        });

function xmlToString(xmlDoc){
      return (typeof XMLSerializer!=="undefined") ?
           (new window.XMLSerializer()).serializeToString(xmlDoc) :
           xmlDoc.xml;
}
</script>
</body>
</html>