package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;

@Controller
@RequestMapping("/articles")
public class ArticleController {

    @Autowired
    private ArticleService articleService;

    @PatchMapping("/{id}")
    @ResponseBody
    public String patchArticle(@RequestBody MultiValueMap<String, String> formParams) {
        System.out.println(formParams);
        long id = Long.parseLong(formParams.getFirst("id"));
        String content = formParams.getFirst("content");
        articleService.updateArticle(id, content);
        return "Article updated.";
    }

    @GetMapping("/{id}")
    public String getArticle(@PathVariable("id") long id, Model model) {
        Article article = articleService.getArticleById(id);
        model.addAttribute("article", article);
        return "article-form";
    }
}