package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

@Component("myTestFilter")
public class MyFilter implements Filter {
    
    @Autowired
    private MyService myService;
    
    @Override
    public void init (FilterConfig filterConfig) throws ServletException {
    }
    
    @Override
    public void doFilter (ServletRequest request, ServletResponse response,
                          FilterChain chain)
              throws IOException, ServletException {
        System.out.println("-- In MyFilter --");
        HttpServletRequest req = (HttpServletRequest) request;
        myService.doSomething(req);
        chain.doFilter(request, response);
    }
    
    @Override
    public void destroy () {
        
    }
}