package com.logicbig.example;

import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer;

import javax.servlet.Filter;

public class AppInitializer extends
          AbstractAnnotationConfigDispatcherServletInitializer {
    
    @Override
    protected Class<?>[] getRootConfigClasses () {
        return null;
    }
    
    @Override
    protected Class<?>[] getServletConfigClasses () {
        return new Class<?>[]{MyWebConfig.class};
    }
    
    @Override
    protected Filter[] getServletFilters () {
        DelegatingFilterProxy filterProxy = new DelegatingFilterProxy();
        filterProxy.setTargetBeanName("myTestFilter");
        return new Filter[]{filterProxy};
    }
    
    @Override
    protected String[] getServletMappings () {
        return new String[]{"/"};
    }
}