package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.Arrays;
import java.util.List;

@Component
public class ExampleClient {

    @Autowired
    private EmployeeRepository repo;

    public void run() {
        List<Employee> employees = createEmployees();
        repo.saveAll(employees);

        System.out.println(" -- finding all employees --");
        Iterable<Employee> all = repo.findAll();
        all.forEach(System.out::println);

        System.out.println(" -- finding by dept Admin  --");
        List<Employee> list = repo.findByDepartment("Admin");
        list.forEach(System.out::println);
    }

    private List<Employee> createEmployees() {
        return Arrays.asList(
                Employee.create("Diana", "Admin", 2000),
                Employee.create("Mike", "Sale", 1000),
                Employee.create("Rose", "IT", 4000),
                Employee.create("Sara", "Admin", 3500),
                Employee.create("Randy", "Sale", 3000),
                Employee.create("Charlie", "IT", 2500)
        );
    }
}