package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import java.util.Arrays;
import java.util.List;

@Component
public class ExampleClient {

    @Autowired
    private EmployeeRepository repo;

    public void run() {
        List<Employee> employees = createEmployees();
        repo.saveAll(employees);

        System.out.println(" -- finding all employees --");
        Iterable<Employee> all = repo.findAll();
        all.forEach(System.out::println);

        System.out.println(" -- finding by dept Sales sort by 'salary' and 'name'  --");
        List<Employee> list = repo.findByDept("Sales", Sort.by("salary", "name").ascending());
        list.forEach(System.out::println);
    }

    private List<Employee> createEmployees() {
        return Arrays.asList(
                Employee.create("Diana", "Sales", 2000),
                Employee.create("Mike", "Sales", 1000),
                Employee.create("Rose", "IT", 4000),
                Employee.create("Sara", "Sales", 3000),
                Employee.create("Andy", "Sales", 3000),
                Employee.create("Charlie", "IT", 2500)
        );
    }
}