package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.Arrays;
import java.util.List;

@Component
public class ExampleClient {

    @Autowired
    private EmployeeRepository repo;

    public void run() {
        List<Employee> employees = createEmployees();
        repo.saveAll(employees);

        System.out.println(" -- finding all employees --");
        Iterable<Employee> all = repo.findAll();
        all.forEach(System.out::println);

        for (int i = 1; i <= 6; i++) {
            System.out.printf(" --  finding employees have top %s salaries in IT dept  --%n", i);
            List<Employee> es = repo.findByDeptTopNSalaries(i, "IT");
            es.forEach(System.out::println);
        }
    }

    private List<Employee> createEmployees() {
        return Arrays.asList(
                Employee.create("Diana", "IT", 2000),
                Employee.create("Mike", "IT", 1000),
                Employee.create("Rose", "IT", 4000),
                Employee.create("Sara", "IT", 3500),
                Employee.create("Randy", "Admin", 3000),
                Employee.create("Linda", "IT", 3000),
                Employee.create("Charlie", "Admin", 2500)
        );
    }
}