package com.logicbig.example;

import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import java.util.List;

public interface EmployeeRepository extends CrudRepository<Employee, Long> {
    @Query("SELECT e FROM Employee e WHERE e.dept = :dept AND "
            + "(SELECT COUNT(DISTINCT e2.salary) FROM Employee e2 "
            + "WHERE e.salary < e2.salary AND e2.dept = :dept) < :topSalNum "
            + "ORDER BY e.salary DESC")
    List<Employee> findByDeptTopNSalaries(@Param("topSalNum") long topSalaryNum, @Param("dept") String dept);
}