package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.*;
import org.springframework.stereotype.Component;
import java.util.Arrays;
import java.util.List;

@Component
public class ExampleClient {

    @Autowired
    private EmployeeRepository repo;

    public void run() {
        List<Employee> employees = createEmployees();
        repo.saveAll(employees);

        System.out.println(" -- finding all employees --");
        Iterable<Employee> all = repo.findAll();
        all.forEach(System.out::println);
        System.out.println(" -- paginating where dept is Sales --");
        Page<Employee> page = null;
        Pageable pageable = PageRequest.of(0, 3, Sort.by("salary"));
        while (true) {
            page = repo.findByDept("Sales", pageable);
            int number = page.getNumber();
            int numberOfElements = page.getNumberOfElements();
            int size = page.getSize();
            long totalElements = page.getTotalElements();
            int totalPages = page.getTotalPages();
            System.out.printf("page info - page number %s, numberOfElements: %s, size: %s, "
                            + "totalElements: %s, totalPages: %s%n",
                    number, numberOfElements, size, totalElements, totalPages);
            List<Employee> employeeList = page.getContent();
            employeeList.forEach(System.out::println);
            if (!page.hasNext()) {
                break;
            }
            pageable = page.nextPageable();
        }
    }

    private List<Employee> createEmployees() {
        return Arrays.asList(
                Employee.create("Diana", "Sales", 2000),
                Employee.create("Mike", "Sales", 1000),
                Employee.create("Rose", "IT", 4000),
                Employee.create("Sara", "Sales", 3000),
                Employee.create("Andy", "Sales", 3000),
                Employee.create("Charlie", "Sales", 2500),
                Employee.create("Jim", "Sales", 4500),
                Employee.create("Sam", "Sales", 2500),
                Employee.create("Adam", "Sales", 5000),
                Employee.create("Jane", "Sales", 5500),
                Employee.create("Joe", "Sales", 1500)
        );
    }
}