package com.logicbig.example;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public interface EmployeeRepository extends CrudRepository<Employee, Long> {

    @Transactional
    @Modifying
    int deleteByNameAndDept(String name, String dept);

    @Transactional
    @Modifying
    int deleteBySalaryGreaterThanEqual(int salary);
}