package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.Arrays;
import java.util.List;

@Component
public class ExampleClient {

    @Autowired
    private EmployeeRepository repo;

    public void run() {
        List<Employee> employees = createEmployees();
        repo.saveAll(employees);

        System.out.println(" -- finding all employees --");
        Iterable<Employee> all = repo.findAll();
        all.forEach(System.out::println);

        System.out.println(" -- finding all EmployeeInfo --");
        List<EmployeeInfo> list = repo.findBy();
        for (EmployeeInfo es : list) {
            System.out.printf("Name: %s, Salary: %s%n", es.getName(), es.getSalary());
        }

        System.out.println(" -- finding the EmployeeInfo in IT dept --");
        list = repo.findByDept("IT");
        for (EmployeeInfo es : list) {
            System.out.printf("Name: %s, Salary: %s%n", es.getName(), es.getSalary());
        }
    }

    private List<Employee> createEmployees() {
        return Arrays.asList(
                Employee.create("Diana", "Admin", 3000),
                Employee.create("Mike", "IT", 1000),
                Employee.create("Rose", "Admin", 4000),
                Employee.create("Sara", "Admin", 3500),
                Employee.create("Tanaka", "IT", 3000),
                Employee.create("Charlie", "IT", 4500)
        );
    }
}