package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.GenericStoredProcedure;
import org.springframework.jdbc.object.StoredProcedure;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.List;
import java.util.Map;

public class JdbcTemplatePersonDao implements PersonDao {

    @Autowired
    private DataSource dataSource;

    private JdbcTemplate jdbcTemplate;

    @PostConstruct
    private void postConstruct() {
        jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public void save(Person person) {
        String sql = "insert into Person (first_Name, Last_Name, Address) values (?, ?, ?)";
        jdbcTemplate.update(sql, person.getFirstName(), person.getLastName(),
                person.getAddress());
    }

    @Override
    public Person load(long id) {
        List<Person> persons = jdbcTemplate.query("select * from Person where id =?",
                new Object[]{id}, (resultSet, i) -> {
                    return toPerson(resultSet);
                });

        if (persons.size() == 1) {
            return persons.get(0);
        }
        return null;
    }

    @Override
    public void delete(long id) {
        jdbcTemplate.update("delete from PERSON where id = ?", id);
    }

    @Override
    public void update(Person person) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAddress(long id, String newAddress) {
        jdbcTemplate.update("update PERSON set ADDRESS = ? where ID = ?"
                , newAddress, id);
    }

    @Override
    public void moveToHistoryTable(Person person) {
        System.out.println("Moving person to history table: "+person);
        StoredProcedure procedure = new GenericStoredProcedure();
        procedure.setDataSource(dataSource);
        procedure.setSql("MOVE_TO_HISTORY");
        procedure.setFunction(false);

        SqlParameter[] parameters = {
                new SqlParameter(Types.BIGINT),
                new SqlOutParameter("status_out", Types.BOOLEAN)
        };

        procedure.setParameters(parameters);
        procedure.compile();

        Map<String, Object> result = procedure.execute(person.getId());
        System.out.println("Status of moving the person to history: " + result);
    }

   /*@Override
    public void moveToHistoryTable(Person person){
        SimpleJdbcCall call = new SimpleJdbcCall(jdbcTemplate)
                .withProcedureName("MOVE_TO_HISTORY")
                . declareParameters(
                        new SqlParameter("person_id_in", Types.BIGINT),
                        new SqlOutParameter("status_out", Types.BOOLEAN));

        Map<String, Object> execute = call.execute(new MapSqlParameterSource("person_id_in", person.getId()));
       logger.info("Status of moving the person to history: "+execute);
    }*/

 /*  @Override
    public void moveToHistoryTable(Person person) {
        List<SqlParameter> parameters = Arrays.asList(
                new SqlParameter(Types.BIGINT), new SqlOutParameter("status_out", Types.BOOLEAN));

        Map<String, Object> t = jdbcTemplate.call(new CallableStatementCreator() {
            @Override
            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                CallableStatement callableStatement = con.prepareCall("{call MOVE_TO_HISTORY (?, ?)}");
                callableStatement.setLong(1, person.getId());
                callableStatement.registerOutParameter(2, Types.BOOLEAN);
                return callableStatement;
            }
        }, parameters);

       logger.info("Status of moving the person to history: "+t.get("status_out"));
    }*/

    @Override
    public List<Person> getPersonsFromHistoryTable() {
        return jdbcTemplate.query("select * from PERSON_HISTORY", (resultSet, i) -> {
            return toPerson(resultSet);
        });
    }

    @Override
    public List<Person> loadAll() {
        return jdbcTemplate.query("select * from Person", (resultSet, i) -> {
            return toPerson(resultSet);
        });
    }

    private Person toPerson(ResultSet resultSet) throws SQLException {
        Person person = new Person();
        person.setId(resultSet.getLong("ID"));
        person.setFirstName(resultSet.getString("FIRST_NAME"));
        person.setLastName(resultSet.getString("LAST_NAME"));
        person.setAddress(resultSet.getString("ADDRESS"));
        return person;
    }


    @Override
    public List<Person> findPersonsByLastName(String name) {
        return jdbcTemplate.query("select * from Person where LAST_NAME = ?",
                new Object[]{name}, new RowMapper<Person>() {
                    @Override
                    public Person mapRow(ResultSet resultSet, int i) throws SQLException {
                        return toPerson(resultSet);
                    }
                });
    }

    @Override
    public Long getPersonCount() {
        return jdbcTemplate.queryForObject("select count(*) from PERSON",
                Long.class);

    }
}