package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.logging.Logger;

public class AppController {
    private static final Logger logger = Logger.getLogger(AppController.class.getName());

    @Autowired
    PersonService personService;

    public void process() {
        Person person = Person.create("Dana", "Whitley", "464 Gorsuch Drive");
        personService.savePerson(person);

        person = Person.create("Robin", "Cash", "64 Zella Park");
        personService.savePerson(person);


        logger.info("person count " + personService.getPersonCount());

        List<Person> persons = personService.getPersonsByLastName("Whitley");

        logger.info("persons found by last name " + persons);

        person = personService.getPersonById(2);

        logger.info("found person by id : " + person);

        logger.info("All persons : " + personService.getAllPersons());

        personService.updateAddress(1, "Jweitt Circle");

        logger.info("Address updated " + personService.getPersonById(1));

        personService.deletePerson(2);

        logger.info("All persons : " + personService.getAllPersons());

    }
}