package com.logicbig.example;

import org.h2.jdbcx.JdbcDataSource;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

import javax.sql.DataSource;

@Configuration
public class AppConfig {

    @Bean
    public PersonService personService() {
        return new PersonService();
    }

    @Bean
    public PersonDao jdbcPersonDao() {
        return new JdbcTemplatePersonDao();
    }

    @Bean
    public DataSource h2DataSource() {
       return new EmbeddedDatabaseBuilder()
                .setType(EmbeddedDatabaseType.H2)
                //.setName("testDB;TRACE_LEVEL_SYSTEM_OUT=3")
                .addScript("createPersonTable.sql")//script to create person table

                .build();
        /*JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:mem:TRACE_LEVEL_SYSTEM_OUT=3;");
        dataSource.setUser("sa");
        dataSource.setPassword("sa");*/

       // return dataSource;

    }

    @Bean
    public AppController appController() {
        return new AppController();
    }

    public static void main(String[] args) {
        AnnotationConfigApplicationContext context =
                new AnnotationConfigApplicationContext(AppConfig.class);
        context.getBean(AppController.class).process();


    }
}