package com.logicbig.example;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalTime;

@Component
public class MyBean {

    @Scheduled(initialDelay = 1000, fixedRate = 1000)
    public void runTask() {
        System.out.printf("Running scheduled task " +
                        " thread: %s, time: %s%n",
                Thread.currentThread().getName(),
                LocalTime.now());
    }

    @Scheduled(initialDelay = 1000,
            fixedRateString = "2000")
    public void runTask2() {
        System.out.printf("Running scheduled task 2" +
                        " thread: %s, time: %s%n",
                Thread.currentThread().getName(),
                LocalTime.now());
    }
}