package com.logicbig.example;

import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

public class MyImportSelector implements ImportSelector {

    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap(
                importingClassMetadata.getAnnotationAttributes(
                        EnableSomeModule.class.getName(), false));

        String value = attributes.getString("value");
        if ("someValue".equals(value)) {
            return new String[]{MyConfig1.class.getName()};
        } else {
            return new String[]{MyConfig2.class.getName()};
        }
    }
}