package com.logicbig.example;

import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.stereotype.Component;

import java.util.Arrays;

@Component
public class ProfileChecker {

    private final Environment env;

    public ProfileChecker(Environment env) {
        this.env = env;
    }

    public void checkProfiles() {
        System.out.println("Active profiles: " +
                                   Arrays.toString(env.getActiveProfiles()));

        // Create a Profiles object for the "dev" OR "staging" environment
        Profiles devOrStaging = Profiles.of("dev|staging");

        if (env.acceptsProfiles(devOrStaging)) {
            System.out.println("Running in a non-production environment "
                                       + "(dev or staging).");
        } else {
            System.out.println("Not running in dev or staging.");
        }

        // Example of a more complex expression: "dev & !cloud"
        Profiles devAndNotCloud = Profiles.of("dev & !cloud");
        System.out.println("dev & !cloud matched? " +
                                   env.acceptsProfiles(devAndNotCloud));
    }
}