package com.logicbig.example;

import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;

import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;

public class SimpleAsyncTaskSchedulerExample {

    public static void main(String[] args) throws InterruptedException {

        SimpleAsyncTaskScheduler scheduler = new SimpleAsyncTaskScheduler();

        scheduler.scheduleAtFixedRate(
                () -> System.out.printf("Thread: %s, Time: %s%n",
                        Thread.currentThread().getName(),
                        LocalTime.now())
                , Duration.of(1, ChronoUnit.SECONDS));

        Thread.sleep(10000);
       //Terminating after 10 seconds
        scheduler.close();
    }
}