package com.logicbig.example;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalTime;

@Component
public class MyBean {

    @Scheduled(fixedDelay = 1000)
    public void runTask() {
        System.out.printf("task thread: %s, time: %s%n",
                Thread.currentThread().getName(),
                LocalTime.now());
    }

    @Scheduled(fixedRate = 2000)
    public void runTask2() {
        System.out.printf("task 2 thread: %s, time: %s%n",
                Thread.currentThread().getName(),
                LocalTime.now());
    }
}