package com.logicbig.example;

import org.springframework.beans.BeanUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class BeanUtilPropDescriptorExample {
    public static void main (String[] args) throws IntrospectionException {
        PropertyDescriptor[] javaDescriptor = Introspector.getBeanInfo(Person.class)
                                                  .getPropertyDescriptors();
        System.out.println("-- jdk property descriptor --");
        printPropertyDescriptor(javaDescriptor);
        PropertyDescriptor[] springDescriptor = BeanUtils.getPropertyDescriptors(Person.class);
        System.out.println("-- spring property descriptor --");
        printPropertyDescriptor(springDescriptor);

    }

    private static void printPropertyDescriptor(PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            System.out.println("Name: "+descriptor.getName());
            System.out.println("Reader: "+descriptor.getReadMethod());
            System.out.println("Writer: "+descriptor.getWriteMethod());
            System.out.println("------");
        }
    }
}