package com.logicbig.example;

import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.ExtendedBeanInfoFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class BeanInfoFactoryExample {
    public static void main (String[] args) throws IntrospectionException {
        System.out.println("-------- using JDK Introspector --");
        BeanInfo beanInfo = Introspector.getBeanInfo(Person.class);
        printPropertyDescriptor(beanInfo.getPropertyDescriptors());

        System.out.println("-------- using Spring BeanInfoFactory --");
        BeanInfoFactory factory = new ExtendedBeanInfoFactory();
        BeanInfo springBeanInfo = factory.getBeanInfo(Person.class);
        printPropertyDescriptor(springBeanInfo.getPropertyDescriptors());
    }

    private static void printPropertyDescriptor(PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            System.out.println("Name: "+descriptor.getName());
            System.out.println("Reader: "+descriptor.getReadMethod());
            System.out.println("Writer: "+descriptor.getWriteMethod());
            System.out.println("------");
        }
    }
}