package com.logicbig.example;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class MyBean implements InitializingBean, DisposableBean {
    private OtherBean otherBean;

    public MyBean() {
        System.out.println("MyBean constructor");
    }

    @Override
    public void afterPropertiesSet() {
        System.out.println("myPostConstruct()");
    }

    @Autowired
    public void setOtherBean(OtherBean otherBean) {
        System.out.println("setOtherBean(): " + otherBean);
        this.otherBean = otherBean;
    }

    public void doSomething() {
        System.out.println("doSomething()");
    }

    @Override
    public void destroy() {
        System.out.println("cleanUp method");
    }
}