package com.logicbig.example;

import com.logicbig.example.beans.Account;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;

@Configuration
@ComponentScan(basePackages = "com.logicbig.example.beans")
public class InjectingArrayOfBeansExample {

    @Bean
    public TestBean testBean(){
        return new TestBean();
    }

    private static class TestBean {
        @Autowired
        @Qualifier("basicAccount")
        private Account[] accounts;

       @PostConstruct
        public void init() {
           System.out.println(Arrays.toString(accounts));
        }
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(
                InjectingArrayOfBeansExample.class);
    }
}