package com.logicbig.example;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import java.io.InputStream;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@Configuration
public class ExampleMain {

    @Bean
    public MyBean myBean() {
        return new MyBean();
    }

    public static void main(String[] args) {
        loadJulLogProperties();

        ConfigurableApplicationContext context =
                new AnnotationConfigApplicationContext(ExampleMain.class);

        MyBean bean = context.getBean(MyBean.class);
        bean.doSomething();
    }

    private static void loadJulLogProperties() {
        try (InputStream stream = ExampleMain.class.getResourceAsStream("/logging.properties")) {
            if (stream != null) {
                //Jul's log manager
                LogManager.getLogManager().readConfiguration(stream);
            } else {
                Logger.getAnonymousLogger().severe("Could not find logging.properties file in classpath");
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}