package com.logicbig.example;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.ScheduledAnnotationBeanPostProcessor;

import java.lang.reflect.Method;


public class CustomScheduledBeanPostProcessor extends ScheduledAnnotationBeanPostProcessor {

    @Override
    protected Runnable createRunnable(Object target, Method method, String qualifier) {
        //do some customizing if required
        Runnable runnable = super.createRunnable(target, method, qualifier);
        return () -> {
            System.out.printf("Running method %s.%s%n",
                    target.getClass().getSimpleName(), method.getName());
            runnable.run();
            System.out.printf("Finished running method %s.%s%n",
                    target.getClass().getSimpleName(), method.getName());
            System.out.println("-------");
        };
    }

    @Override
    protected void processScheduled(Scheduled scheduled, Method method, Object bean) {
        System.out.printf("Processing @Scheduled method: %s.%s, scheduled Type: %s%n",
                method.getDeclaringClass().getSimpleName(), method.getName(), scheduled);
        super.processScheduled(scheduled, method, bean);
    }
}