package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import jakarta.annotation.PostConstruct;

@ComponentScan
@Configuration
public class ExampleMain {

    @Autowired
    private Car car;
    @Autowired
    private Driver driver;

    @PostConstruct
    public void postConstruct() {
        car.drive();
        driver.showCar();
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(ExampleMain.class);
    }
}