package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@Configuration
public class SetAsBeanExample {

    @Bean
    public Set<String> fruits() {
        return new HashSet<>(Arrays.asList("apple", "banana", "orange"));
    }

    @Bean
    public TestBean testBean(){
        return new TestBean();
    }

    private static class TestBean {
        @Autowired
        private Set<String> fruits;

        @PostConstruct
        public void postConstruct() {
            System.out.println(fruits);
        }
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(
                SetAsBeanExample.class);
    }
}