package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;

@Configuration
public class ObjectListAsBeanExample {

    @Bean
    public List<Fruit> fruits() {
        return Arrays.asList(
                new Fruit("apple", "every morning"),
                new Fruit("banana", "after lunch"),
                new Fruit("orange", "every evening")
        );
    }

    @Bean
    public TestBean testBean() {
        return new TestBean();
    }

    private static class TestBean {
        @Autowired
        private List<Fruit> fruits;

        @PostConstruct
        public void postConstruct() {
            System.out.println(fruits);
        }
    }

    private static class Fruit {
        private String name;
        private String whenToEat;

        public Fruit(String name, String whenToEat) {
            this.name = name;
            this.whenToEat = whenToEat;
        }

        @Override
        public String toString() {
            return "Fruit{" +
                    "name='" + name + '\'' +
                    ", whenToEat='" + whenToEat + '\'' +
                    '}';
        }
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(
                ObjectListAsBeanExample.class);
    }
}