package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

@Configuration
public class MapAsBeanExample {

    @Bean
    public HashMap<String, String> fruits() {
        HashMap<String, String> map = new HashMap<>();
        map.put("apple", "every morning");
        map.put("banana", "after lunch");
        map.put("orange", "every evening");
        return map;
    }

    @Bean
    public TestBean testBean(){
        return new TestBean();
    }

    private static class TestBean {
        @Autowired
        private Map<String, String> fruits;

        @PostConstruct
        public void postConstruct() {
            System.out.println(fruits);
        }
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(
                MapAsBeanExample.class);
    }
}