package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;

@Configuration
public class ListAsBeanExample {

    @Bean
    public List<String> fruits() {
        return Arrays.asList("apple", "banana", "orange");
    }

    @Bean
    public TestBean testBean(){
        return new TestBean();
    }

    private static class TestBean {
        @Autowired
        private List<String> fruits;

        @PostConstruct
        public void postConstruct() {
            System.out.println(fruits);
        }
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(
                ListAsBeanExample.class);
    }
}