package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;

@Configuration
public class ArraysAsBeanExample {

    @Bean
    public String[] fruits() {
        return new String[]{"apple", "banana", "orange"};
    }

    @Bean
    public TestBean testBean(){
        return new TestBean();
    }

    private static class TestBean {
        @Autowired
        private String[] fruits;

        @PostConstruct
        public void postConstruct() {
            System.out.println(Arrays.toString(fruits));
        }
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(
                ArraysAsBeanExample.class);
    }
}