package com.logicbig.example;


import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import static org.junit.jupiter.api.Assertions.assertEquals;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = AppConfig.class)
@TestPropertySource("classpath:test.properties")
public class ReportServiceTests {
    @Autowired
    private ReportService reportService;
    @Autowired
    private Environment environment;

    @Test
    public void testReportSubscriber() {
        String s = reportService.getReportSubscriber();
        System.out.println(s);
        assertEquals("theDeveloper@example.com", s);
    }

    @Test
    public void testAllProps(){
        //accessing properties directly
        String subscriber = environment.getProperty("report-subscriber");
        assertEquals("theDeveloper@example.com", subscriber);
        String appName = environment.getProperty("app-name");
        assertEquals("Subscriber App", appName);
        String testsName = environment.getProperty("tests-name");
        assertEquals("Subscriber Tests", testsName);
    }
}