package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.bean.override.convention.TestBean;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.junit.jupiter.api.Assertions.assertEquals;
@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = AppConfig.class)
class TestBeanEnforceOverrideTest {

    @TestBean(name = "messageService", enforceOverride = true)
    MessageService messageService;

    static MessageService messageService() {
        return () -> "test";
    }

    @Test
    void verifyBeanOverride() {
        assertEquals("test", messageService.message());
    }
}