package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.bean.override.convention.TestBean;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import static org.junit.jupiter.api.Assertions.assertTrue;

@ExtendWith(SpringExtension.class)
@ContextHierarchy({
        @ContextConfiguration(classes = ParentConfig.class),
        @ContextConfiguration(classes = ChildConfig.class)
})
public class ContextHierarchyTestBeanTest {

    @Autowired
    private UserService userService;

    @TestBean(name = "database")
    Database database;

    static Database database() {
        return new Database("jdbc:h2:mem:testdb-override");
    }

    @Test
    public void testHierarchyWithTestBean() {
        String result = userService.getUser("john");
        System.out.println("Result: " + result);

        assertTrue(result.contains("testdb-override"));

      ;
    }
}