package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.doReturn;

@SpringJUnitConfig(AppConfig.class)
public class MockitoSpyBeanTest {

    @MockitoSpyBean
    Calculator calculator;

    @Autowired
    MathService mathService;

    @Test
    public void testWithSpiedCalculator() {
        doReturn(100).when(calculator).add(5, 10);

        int addResult = mathService.performAddition(5, 10);
        System.out.println("Add result: " + addResult);
        assertEquals(100, addResult);

        int multiplyResult = mathService.performMultiplication(4, 5);
        System.out.println("Multiply result: " + multiplyResult);
        assertEquals(20, multiplyResult);
    }
}