package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import static org.junit.jupiter.api.Assertions.assertEquals;

@ExtendWith(SpringExtension.class)
@ContextConfiguration
public class ImplicitConfigTest {

    @Autowired
    private String message;

    @Autowired
    private Integer code;

    @Configuration
    static class LocalConfig {
        @Bean
        public String message() {
            return "Implicit Config";
        }
    }

    @Configuration
    static class AdditionalConfig {
        @Bean
        public Integer code() {
            return 200;
        }
    }

    @Test
    void testImplicitDetection() {
        System.out.println("Testing implicit config");
        assertEquals("Implicit Config", message);
        assertEquals(Integer.valueOf(200), code);
    }
}