package com.logicbig.example;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(SpringExtension.class)
@ContextHierarchy({
        @ContextConfiguration(classes = ParentConfig.class),
        @ContextConfiguration(classes = ChildConfig.class)
})
class ContextHierarchyTest {

    @Autowired
    private ApplicationContext context;

    @Autowired
    @Qualifier("childBean")
    private String childBean;

    @Autowired
    @Qualifier("combinedBean")
    private String combinedBean;

    @Test
    public void testContextHierarchy() {
        System.out.println("Child bean: " + childBean);
        System.out.println("Combined bean: " + combinedBean);

        ApplicationContext parent = context.getParent();
        Assertions.assertNotNull(parent);
        System.out.println("Parent exists: true");
        System.out.println("Parent has sharedBean: " + parent.containsBean("sharedBean"));
        System.out.println("Parent has childBean: " + parent.containsBean("childBean"));
    }
}