package com.logicbig.example;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;

public class TestServiceContextCustomizer implements ContextCustomizer {

    @Override
    public void customizeContext(
            ConfigurableApplicationContext context,
            MergedContextConfiguration mergedConfig) {

        GenericApplicationContext gac =
                (GenericApplicationContext) context;
        gac.registerBean(TestService.class, TestService::new);
    }
}