package com.logicbig.example;

import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import java.util.List;

public class GreetingServiceContextCustomizerFactory 
        implements ContextCustomizerFactory {
    
    @Override
    public ContextCustomizer createContextCustomizer(
            Class<?> testClass,
            List<ContextConfigurationAttributes> configAttributes) {
        
        EnableGreetingServiceMock annotation = 
            testClass.getAnnotation(EnableGreetingServiceMock.class);
        
        if (annotation == null) {
            return null;
        }
        
        return new GreetingServiceContextCustomizer(
                annotation.message());
    }
}