package com.logicbig.example;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class TestStringBeanOverrideProcessor implements BeanOverrideProcessor {

    @Override
    public BeanOverrideHandler createHandler(Annotation overrideAnnotation,
                                             Class<?> testClass,
                                             Field field) {
        TestString annotation = field.getAnnotation(TestString.class);
        String testValue = annotation.value();

        return new TestStringBeanOverrideHandler( testValue, field);
    }

    private static class TestStringBeanOverrideHandler extends BeanOverrideHandler {

        private final String testValue;

        public TestStringBeanOverrideHandler(String testValue,
                                             Field field) {
            super(field, ResolvableType.forType(field.getGenericType()), field.getName(),
                  "", BeanOverrideStrategy.REPLACE);
            this.testValue = testValue;
        }


        @Override
        protected Object createOverrideInstance(String beanName,
                                                @Nullable BeanDefinition existingBeanDefinition,
                                                @Nullable Object existingBeanInstance) {
            // Simply return the test value, ignoring the existing bean

            return testValue;
        }
    }
}