package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;
import static org.junit.jupiter.api.Assertions.assertEquals;

@SpringJUnitConfig(ApiServiceTest.AppConfig.class)
class ApiServiceTest {

    @TestString("https://api.test.com")
    private String apiUrl;

    @Test
    void testApiCall() {
        // The apiUrl bean in the context is now "https://api.test.com"
        System.out.println("overridden: " + apiUrl);
        assertEquals("https://api.test.com", apiUrl);
    }

    @Configuration
    static class AppConfig {

        @Bean
        public String apiUrl() {
            return "https://api.production.com";
        }


    }
}