package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import java.util.Arrays;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

@DevMySqlTest
public class UserServiceTest {

    @Autowired
    private Environment environment;

    @Test
    public void testProfiles() {
        String[] profiles = environment.getActiveProfiles();
        System.out.println("Active profiles (UserServiceTest): " +
                                   Arrays.toString(profiles));

        // Assertions
        assertTrue(Arrays.asList(profiles).contains("dev"));
        assertTrue(Arrays.asList(profiles).contains("mysql"));
        assertFalse(Arrays.asList(profiles).contains("prod"));
        assertFalse(Arrays.asList(profiles).contains("postgres"));

        // Environment convenience with Profiles.of
        assertTrue(environment.acceptsProfiles(
                Profiles.of("dev & mysql")));
        assertFalse(environment.acceptsProfiles(Profiles.of("prod")));
    }
}