package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

import java.util.Arrays;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

@ProdPostgresTest
public class ReportServiceTest {

    @Autowired
    private Environment environment;

    @Test
    public void testReport() {
        // has [prod, postgres] profiles
        String[] profiles = environment.getActiveProfiles();
        System.out.println("Active profiles (ReportServiceTest): " +
                                   Arrays.toString(profiles));

        assertTrue(Arrays.asList(profiles).contains("prod"));
        assertTrue(Arrays.asList(profiles).contains("postgres"));
        assertFalse(Arrays.asList(profiles).contains("dev"));
        assertFalse(Arrays.asList(profiles).contains("mysql"));

        assertTrue(environment.acceptsProfiles(
                Profiles.of("prod & postgres")));
        assertFalse(environment.acceptsProfiles(
                Profiles.of("dev | mysql")));
    }
}