package com.logicbig.example;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

import javax.sql.DataSource;

@Configuration
public class AppConfig {

    // Minimal DataSource beans for demo purposes only;
    // no real DB connectivity required.
    @Bean
    @Profile({"dev", "mysql"})
    public DataSource devMySqlDataSource() {
        DriverManagerDataSource ds = new DriverManagerDataSource();
        ds.setUrl("jdbc:mysql://localhost:3306/demo");
        ds.setUsername("demo");
        ds.setPassword("demo");
        return ds;
    }

    @Bean
    @Profile({"prod", "postgres"})
    public DataSource prodPostgresDataSource() {
        DriverManagerDataSource ds = new DriverManagerDataSource();
        ds.setUrl("jdbc:postgresql://localhost:5432/demo");
        ds.setUsername("demo");
        ds.setPassword("demo");
        return ds;
    }
}