package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.core.env.Profiles;
import org.springframework.test.context.ActiveProfiles;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

@ActiveProfiles(value = "prod", inheritProfiles = false)
public class ProdTest extends BaseTest {

    @Test
    public void test() {
        // Active profiles should only include prod (no inheritance)
        String[] profiles = env.getActiveProfiles();
        assertFalse(contains(profiles, "base"),
                    "'base' should NOT be active (inheritance disabled)");
        assertTrue(contains(profiles, "prod"),
                   "'prod' should be active (declared)");
        assertFalse(contains(profiles, "dev"),
                    "'dev' should not be active");

        // Environment-based checks (using Profiles.of)
        assertTrue(env.acceptsProfiles(Profiles.of("prod")));
        assertFalse(env.acceptsProfiles(Profiles.of("dev")));
        assertFalse(env.acceptsProfiles(Profiles.of("base")));
    }
}