package com.logicbig.example;

import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;
import java.time.LocalTime;

public class FlatMapOperationExample6Concurrency {
    public static void main(String[] args) {
        System.out.println("-- Mapping Flux elements --");
        Flux.just(1, 2, 3)
            .flatMap(integer -> {
                System.out.println("-----------");
                return Flux.range(integer, integer * 2)
                           .subscribeOn(Schedulers.newParallel("myThread", 8));
            }, 1)
            .subscribe(e -> System.out.println(e + " - " + Thread.currentThread().getName() + " - " + LocalTime.now()));
    }
}