package com.logicbig.example;

import reactor.core.publisher.Flux;

public class FlatMapOperationExample3WithError {
    public static void main(String[] args) {
        System.out.println("-- Mapping Flux elements with error --");
        Flux.just(1, 2, 3)
            .map(i -> {
                if (i == 2) {
                    throw new IllegalArgumentException("test exception");
                }
                return i + 1;
            })
            .flatMap(integer -> {
                System.out.println("-----------");
                return Flux.range(integer, integer * 2);
            }, throwable -> {
                System.out.println("error: " + throwable);
                return Flux.just(100);
            }, () -> Flux.just(200))
            .subscribe(System.out::println);

    }
}