package com.logicbig.example;

import reactor.core.publisher.Flux;

public class FlatMapOperationExample2WithoutError {
    public static void main(String[] args) {
        System.out.println("-- Mapping Flux elements without error --");
        Flux.just(1, 2, 3)
            .flatMap(integer -> {
                System.out.println("-----------");
                return Flux.range(integer, integer * 2);
            }, throwable -> {
                System.out.println("error: " + throwable);
                return Flux.just(100);
            }, () -> Flux.just(200))
            .subscribe(System.out::println);

    }
}