package com.logicbig.example;

import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import java.util.function.Function;

public class FlatMapOperationExample {
    public static void main(String[] args) {
        System.out.println("-- Mapping Flux elements --");
        Flux.just(1, 2, 3)
            .flatMap( integer -> {
                System.out.println("-----------");
                return Flux.range(integer, integer*2);
            })
            .subscribe(System.out::println);

        System.out.println("-- Mapping Mono element --");
        Mono.just("supercalifragilisticexpialidocious")
            .flatMap(s -> Mono.just(s.length()))
            .subscribe(System.out::println);
    }
}