package com.logicbig.example;

import org.fluttercode.datafactory.impl.DataFactory;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.TreeNode;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;

@ManagedBean
@ViewScoped
public class TreeBean {
    private TreeNode treeNode;

    public TreeBean() {
        treeNode = new DefaultTreeNode("Employees", null);
        DataFactory dataFactory = new DataFactory();
        for (int i = 0; i < 5; i++) {
            String[] employees = new String[10];
            for (int j = 0; j < 10; j++) {
                employees[j] = dataFactory.getName();
            }
            String company = dataFactory.getBusinessName();
            addNode(treeNode, company, employees);
        }
    }

    private void addNode(TreeNode parentNode, String nodeName, String... children) {
        TreeNode node = new DefaultTreeNode(nodeName, parentNode);
        node.setExpanded(true);
        if (children != null) {
            for (String child : children) {
                addNode(node, child, null);
            }
        }
    }

    public TreeNode getTreeNode() {
        return treeNode;
    }
}